﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MicroRWD.Common
{
    #region EventArgs

    // Acknowledge event arguments
    public class AcknowledgeEventArgs : EventArgs
    {
        #region Public Properties

        // The latest acknowledge value
        public byte Value { get; set; }

        #endregion


        #region Constructor

        // Constructs a new acknowledge event arguments instance
        public AcknowledgeEventArgs(byte _value)
        {
            Value = _value;
        }

        #endregion
    }

    #endregion


    #region Delegates

    // Delegate to handle despatch of acknowledge events
    public delegate void AcknowledgeEventHandler(object sender, AcknowledgeEventArgs args);

    #endregion
}
